module RPG
  class Actor
    def initialize
      @id = 0
      @name = ""
      @class_id = 1
      @initial_level = 1
      @final_level = 99
      @exp_basis = 30
      @exp_inflation = 30
      @character_name = ""
      @character_hue = 0
      @battler_name = ""
      @battler_hue = 0
      @parameters = Table.new(6,100)
      for i in 1..99
        @parameters[0,i] = 500+i*50
        @parameters[1,i] = 500+i*50
        @parameters[2,i] = 50+i*5
        @parameters[3,i] = 50+i*5
        @parameters[4,i] = 50+i*5
        @parameters[5,i] = 50+i*5
      end
      @weapon_id = 0
      @armor1_id = 0
      @armor2_id = 0
      @armor3_id = 0
      @armor4_id = 0
      @weapon_fix = false
      @armor1_fix = false
      @armor2_fix = false
      @armor3_fix = false
      @armor4_fix = false
    end
    attr_accessor :id
    attr_accessor :name
    attr_accessor :class_id
    attr_accessor :initial_level
    attr_accessor :final_level
    attr_accessor :exp_basis
    attr_accessor :exp_inflation
    attr_accessor :character_name
    attr_accessor :character_hue
    attr_accessor :battler_name
    attr_accessor :battler_hue
    attr_accessor :parameters
    attr_accessor :weapon_id
    attr_accessor :armor1_id
    attr_accessor :armor2_id
    attr_accessor :armor3_id
    attr_accessor :armor4_id
    attr_accessor :weapon_fix
    attr_accessor :armor1_fix
    attr_accessor :armor2_fix
    attr_accessor :armor3_fix
    attr_accessor :armor4_fix





    ###########################################
    # Ajouts aux classes
    ###########################################


    def to_dmk
      my = self.cast(My_RPG::My_Actor)
      return my
    end



    def comparer(actor)
      #return false if actor.is_a?(self.class) == false

      if @id != actor.id
        raise(DMKW_DMK_Diff.new("actor.id"))
      end
      if @name != actor.name
        raise(DMKW_DMK_Diff.new("actor.name"))
      end
      if @class_id != actor.class_id
        raise(DMKW_DMK_Diff.new("actor.class_id"))
      end
      if @initial_level != actor.initial_level
        raise(DMKW_DMK_Diff.new("actor.initial_level"))
      end
      if @final_level != actor.final_level
        raise(DMKW_DMK_Diff.new("actor.final_level"))
      end
      if @exp_basis != actor.exp_basis
        raise(DMKW_DMK_Diff.new("actor.exp_basis"))
      end
      if @exp_inflation != actor.exp_inflation
        raise(DMKW_DMK_Diff.new("actor.exp_inflation"))
      end
      if @character_name != actor.character_name
        raise(DMKW_DMK_Diff.new("actor.character_name"))
      end
      if @character_hue != actor.character_hue
        raise(DMKW_DMK_Diff.new("actor.character_hue"))
      end
      if @battler_name != actor.battler_name
        raise(DMKW_DMK_Diff.new("actor.battler_name"))
      end
      if @battler_hue != actor.battler_hue
        raise(DMKW_DMK_Diff.new("actor.battler_hue"))
      end
      if @parameters.comparer(actor.parameters) == false
        raise(DMKW_DMK_Diff.new("actor.parameters"))
      end
      if @weapon_id != actor.weapon_id
        raise(DMKW_DMK_Diff.new("actor.weapon_id"))
      end
      if @armor1_id != actor.armor1_id
        raise(DMKW_DMK_Diff.new("actor.armor1_id"))
      end
      if @armor2_id != actor.armor2_id
        raise(DMKW_DMK_Diff.new("actor.armor2_id"))
      end
      if @armor3_id != actor.armor3_id
        raise(DMKW_DMK_Diff.new("actor.armor3_id"))
      end
      if @armor4_id != actor.armor4_id
        raise(DMKW_DMK_Diff.new("actor.armor4_id"))
      end
      if @weapon_fix != actor.weapon_fix
        raise(DMKW_DMK_Diff.new("actor.weapon_fix"))
      end
      if @armor1_fix != actor.armor1_fix
        raise(DMKW_DMK_Diff.new("actor.armor1_fix"))
      end
      if @armor2_fix != actor.armor2_fix
        raise(DMKW_DMK_Diff.new("actor.armor2_fix"))
      end
      if @armor3_fix != actor.armor3_fix
        raise(DMKW_DMK_Diff.new("actor.armor3_fix"))
      end
      if @armor4_fix != actor.armor4_fix
        raise(DMKW_DMK_Diff.new("actor.armor4_fix"))
      end

      return true
    end





  end



end
